package ZeitschriftPlain;

use strict;
use warnings;

use Carp 'confess';

sub new {
    my $class = shift;
    my %args  = @_;
    my $self  = {};

    if (exists $args{issue}) {
        confess "Attribute (issue) does not pass the type constraint because: Validation failed for 'Int' with value $args{issue}"
            if ref($args{issue}) || $args{issue} !~ /\A[+-]?\d+\z/;
        $self->{issue} = $args{issue};
    }
    
    for my $attr ( qw/title publisher/ ) {
        if (exists $args{$attr}) {
            my $value = $args{$attr};
            confess "Attribute ($attr) does not pass the type constraint because: Validation failed for 'Str' with value $value"
                if ref($args{$attr});
            $self->{$attr} = $args{$attr};
        }
    }

    return bless $self, $class;
}

sub issue {
    my $self = shift;

    if (@_) {
        my $value = shift;
        confess "Attribute (issue) does not pass the type constraint because: Validation failed for 'Int' with value $value"
            if ref($value) || $value !~ /\A[+-]?\d+\z/;
        $self->{issue} = $value;
    }

    return $self->{issue};
}

sub title {
    my $self = shift;
    
    confess "Cannot assign a value to a read-only accessor" if @_;

    return $self->{title};
}

sub publisher {
    my $self = shift;
    
    confess "Cannot assign a value to a read-only accessor" if @_;

    return $self->{publisher};
}

1;