package ZeitschriftSubtype;

use Moose;
use Moose::Util::TypeConstraints;

subtype positiveInt =>
    as 'Int' =>
    where { $_ > 0; }
;

has title     => (
    reader => 'get_title',
    writer => 'set_title',
    isa => 'Str',
);

has pages => (
    is => 'rw',
    isa => 'positiveInt',
);

has issue     => ( is => 'rw', isa => 'Int' );
has publisher => ( is => 'ro', isa => 'Str' );

1;