   use strict;
   use warnings;
   
   #Initialisierung des Perl Moduls Gtk2
   #!muss ausgeführt werden bevor
   #andere Funktionen des Moduls verwendet werden!
   use Gtk2 '-init';

   use Gtk2::Gdk::Keysyms;

   #Erstellung eines neuen Fensters
   my $window = Gtk2::Window->new;

   #Erstelle einen neuen Button
   my $button = Gtk2::Button->new ('Bildschirmfoto aufnehmen');
   $button->signal_connect (clicked => \&button_callback);
   
   #Erstelle einen neuen Button
   my $button2 = Gtk2::Button->new ('Bereich aufnehmen');
   $button2->signal_connect (clicked => \&select_callback);
   
   my $image = Gtk2::Image->new;
   
   #Erstelle einen Container mit vertikaler Ausrichtung
   my $vbox = Gtk2::VBox->new;
   
   #Packe den Button in die VBox
   $vbox->pack_start_defaults($button);
   $vbox->pack_start_defaults($button2);
   $vbox->pack_start_defaults($image);
   
   #Füge nun die VBox zum Fenster hinzu
   $window->add ($vbox);
   
   #Zeichne das Fenster und den Inhalt (rekursiv)
   $window->show_all;
   
   #Starte die Ereignisschleife (event loop)
   Gtk2->main;

   #Diese Funktion wird aufgerufen, wenn der Button
   #das Ereignis 'clicked' erhält
   sub button_callback {
		my $root = Gtk2::Gdk->get_default_root_window;
      my ( $x, $y, $w, $h ) = $root->get_geometry;
      my $pixbuf = Gtk2::Gdk::Pixbuf->get_from_drawable( $root, undef, $x, $y, 0, 0, $w, $h );
      #~ $pixbuf->save("/home/mario/Desktop/test.png", 'png');
      $image->set_from_pixbuf($pixbuf->scale_simple(640, 480, 'bilinear'));
   }
   
   sub select_callback {
      my $root = Gtk2::Gdk->get_default_root_window;
      
      Gtk2::Gdk->pointer_grab( $root, 0,
         [qw/  
            pointer-motion-mask
            button-press-mask
            button-release-mask
         /],
         undef, undef, Gtk2->get_current_event_time
      );
      
      Gtk2::Gdk->keyboard_grab( $root, 0, Gtk2->get_current_event_time );
      
      if ( Gtk2::Gdk->pointer_is_grabbed ) {
   
         #Hilfsvariable, um den Status der Maustaste zu bestimmen
         my $btn_pressed = 0;
         
         #Startkoordinaten und Abmessungen des Rechtecks
         my ( $rx, $ry, $rect_x, $rect_y, $rect_w, $rect_h ) = ( 0, 0, 0, 0, 0, 0 );
   
         #GC definieren
         my $gc = Gtk2::Gdk::GC->new( $root, undef );
         $gc->set_line_attributes( 1, 'double-dash', 'butt', 'round' );
         $gc->set_rgb_fg_color(Gtk2::Gdk::Color->new( 65535, 65535, 65535 ));
         $gc->set_subwindow('include-inferiors');
         $gc->set_function('xor');
   
         Gtk2::Gdk::Event->handler_set(sub {
            my $event = shift;
            
            if ( $event->type eq 'key-press' ) {
               #ESC-Taste wird gedrückt => beenden
               if ( $event->keyval == $Gtk2::Gdk::Keysyms{Escape} ) {
                  Gtk2::Gdk->pointer_ungrab( Gtk2->get_current_event_time );
                  Gtk2::Gdk->keyboard_ungrab( Gtk2->get_current_event_time );
                  Gtk2::Gdk::Event->handler_set( undef, undef );
               }
            } elsif ( $event->type eq 'motion-notify' ) {
               #Wenn Maustaste gedrückt, dann wird das Rechteck gezeichnet
               if ($btn_pressed) {
                  #Das letzte gezeichnete Rechteck wieder entfernen 
                  #siehe $gc->set_function('xor');
                  if ( $rect_w > 0 ) {
                     $root->draw_rectangle( $gc, 0, $rect_x, $rect_y, $rect_w, $rect_h );
                  }
                  
                  #Abmessungen des neuen Rechtecks bestimmen
                  $rect_x = $rx;
                  $rect_y = $ry;
                  $rect_w = $event->x - $rect_x;
                  $rect_h = $event->y - $rect_y;
                  if ( $rect_w < 0 ) {
                     $rect_x += $rect_w;
                     $rect_w = -$rect_w;
                  }
                  if ( $rect_h < 0 ) {
                     $rect_y += $rect_h;
                     $rect_h = -$rect_h;
                  }
                  
                  #Rechteck zeichnen
                  if ( $rect_w != 0 ) {               
                      $root->draw_rectangle( $gc, 0, $rect_x, $rect_y, $rect_w, $rect_h );
                  }
               }
            } elsif ( $event->type eq 'button-press' ) {
               #Maustaste wurde gedrückt
               $btn_pressed = 1;
               #Koordinaten festhalten
               $rx = $event->x;
               $ry = $event->y;
            } elsif ( $event->type eq 'button-release' ) {
               if ( $rect_w > 1 ) {
                  #Das letzte gezeichnete Rechteck wieder entfernen
                  #siehe $gc->set_function('xor');
                  $root->draw_rectangle( $gc, 0, $rect_x, $rect_y, $rect_w, $rect_h );
                  
                  Gtk2::Gdk->pointer_ungrab( Gtk2->get_current_event_time );
                  Gtk2::Gdk->keyboard_ungrab( Gtk2->get_current_event_time );
                  Gtk2::Gdk::Event->handler_set( undef, undef );
                  
                  my $pixbuf = Gtk2::Gdk::Pixbuf->get_from_drawable( $root, undef, $rect_x, $rect_y, 0, 0, $rect_w, $rect_h );
                  $image->set_from_pixbuf($pixbuf);            
               }
            }
         
         });  
         
      }
          
   }  
   
   1;
