package FooApp::Zeitschrift;

use Moose;
use Moose::Util::TypeConstraints;

subtype 'Article' => as 'Object' => where { $_->isa( 'FooApp::Zeitschrift::Article' ) };
subtype 'ISSN'    => as 'Str'    => where { $_ =~ m{ \A [0-9]{4} - [0-9]{4} \z }xms };

has Articles => (
    is         => 'rw',
    isa        => 'ArrayRef[Article]',
    auto_deref => 1,
);

has ISSN    => ( is => 'ro', isa => 'ISSN' );
has Imprint => ( is => 'ro', isa => 'Str'  );
has Title   => ( is => 'ro', isa => 'Str', required => 1  );
has IssueNr => ( is => 'ro', isa => 'Int', required => 1  );

has PreferredOutput => ( is => 'ro', isa => 'Str', default => 'text' );

sub publish {
    my ($self) = @_;
    
    warn "<publish> @_\n";
    
    my $articles = '';
    $articles .= $_->render . "\n\n" for $self->Articles;
    
    my $text = sprintf "%s - %s\n%s\n\n\n%s",
        $self->Title,
        $self->IssueNr,
        $self->ISSN || '',
        $articles;
    
    return $text;
}

sub as_xml {
    my ($self) = @_;
    
    my $inner = inner();
    return sprintf '<zeitschrift>%s</zeitschrift>', $inner;
}

1;