package FooApp::Zeitschrift::FooMagazin;

use Moose;

extends 'FooApp::Zeitschrift';

has 'PreferredOutput' => ( is => 'rw', isa => 'Str', default => 'PDF' );

after 'publish' => sub {
    print "send announcement...\n";
};

augment 'as_xml' => sub {
    my ($self) = @_;
  
    my $title  = $self->Title;
    my $issn   = $self->ISSN;
    my $inner  = inner();
  
    my $format = <<'    FORMAT';
  
    <titel>%s</title>
    <issn>%s</issn>
    %s
    FORMAT
  
    my $xml = sprintf $format, $title, $issn, $inner;
    return $xml;
};

1;