#!/usr/bin/perl

use strict;
use warnings;

use FindBin;
use lib $FindBin::Bin . '/lib';

use FooApp::Zeitschrift::FooMagazin;
use FooApp::Zeitschrift::Article;
use FooApp::Zeitschrift::FooMagazin::SpecialEdition;
use FooApp::Zeitschrift::SchoenerProgrammieren;

my @articles = (
    FooApp::Zeitschrift::Article->new( Titel => 'Test1', Text => 'Text1', Author => 'reneeb' ),
    FooApp::Zeitschrift::Article->new( Titel => 'Test2', Text => 'Text2', Author => 'lichtkind' ),
    FooApp::Zeitschrift::Article->new( Titel => 'Test3', Text => 'Text3', Author => 'lanx' ),
);

my $foo = FooApp::Zeitschrift::FooMagazin->new(
    Articles => \@articles,
    IssueNr  => 16,
    ISSN     => '1234-5678',
    Title    => '$foo - Perl-Magazin',
);

#print $foo->publish( 1 );

#print $foo->as_xml;

my $zeit = FooApp::Zeitschrift::SchoenerProgrammieren->new(
    Articles => \@articles,
    IssueNr  => 16,
    ISSN     => '1234-5678',
    Title    => '$foo - Perl-Magazin',
);

print $zeit->publish;