#!/usr/bin/perl

use SDL::Image;
use SDL::Surface;
use SDLx::App;
use SDLx::LayerManager;
use SDLx::Layer;

my $display = SDLx::App->new(title => 'Games::Solitaire',
                             width => 800, height => 600, depth => 32,
                             flags => SDL_HWSURFACE | SDL_HWACCEL);
my $layers  = SDLx::LayerManager->new();

init_background();
$layers->blit($display);
$display->flip();

sleep(5);

sub init_background {

  # Hintergrundbild
  my $background  = SDL::Image::load('data/background.jpg');
  $layers->add(SDLx::Layer->new($background, {id => 'background'}));

  my $empty_stack = SDL::Image::load('data/empty_stack.png');

  # zwei Platzhalter fr Kartenstapel oben links
  $layers->add(SDLx::Layer->new($empty_stack,  20, 20, {id => 'rewind_deck'}));
  $layers->add(SDLx::Layer->new($empty_stack, 130, 20, {id => 'empty_deck'}));

  # sieben Stapel unten
  for(0..6) {
    $layers->add(SDLx::Layer->new($empty_stack, 20+110*$_, 200, {id => 'empty_stack'}));
  }

  # vier Stapel oben rechts
  for(0..3) {
    $empty_target = SDL::Image::load('data/empty_target_' . $_ . '.png');
    $layers->add(SDLx::Layer->new($empty_target, 350+110*$_, 20, {id=>"empty_target_$_"}));
  }
}
