#!/usr/bin/perl

use Time::HiRes;
use SDL::Events;
use SDL::Event;
use SDL::Image;
use SDL::Surface;
use SDLx::App;
use SDLx::LayerManager;
use SDLx::Layer;
use SDLx::FPS;

my $display         = SDLx::App->new(title => 'Games::Solitaire',
                                     width => 800, height => 600, depth => 32,
                                     flags => SDL_HWSURFACE | SDL_HWACCEL);
my $layers          = SDLx::LayerManager->new();
my $event           = SDL::Event->new();
my $loop            = 1;
my $last_click      = Time::HiRes::time;
my $fps             = SDLx::FPS->new(fps => 60);
my $left_mouse_down = 0;
my $handler         = {};

init_background();
$layers->blit($display);
$display->flip();
game();

sub event_loop {
    SDL::Events::pump_events();
    while(SDL::Events::poll_event($event)) {
        my $type = $event->type;

        if ($type == SDL_MOUSEBUTTONDOWN) {
            $left_mouse_down = 1 if $event->button_button == SDL_BUTTON_LEFT;
            my $time = Time::HiRes::time;
            if ($time - $last_click >= 0.3) {
                $handler->{on_click}->();
            }
            else {
                $handler->{on_dblclick}->();
            }
            $last_click = $time;
        }
        elsif ($type == SDL_MOUSEMOTION) {
            if ($left_mouse_down) {
                $handler->{on_drag}->();
            }
            else {
                $handler->{on_mousemove}->();
            }
        }
        elsif ($type == SDL_MOUSEBUTTONUP) {
            $left_mouse_down = 0 if $event->button_button == SDL_BUTTON_LEFT;
            $handler->{on_drop}->();
        }
        elsif ($type == SDL_KEYDOWN) {
            $handler->{on_keydown}->();
        }
        elsif ($type == SDL_QUIT) {
            $handler->{on_quit}->();
        }
    }
}

sub game {
    $handler = {
        on_quit      => sub {
            $loop = 0;
        },
        on_drag      => sub {
            printf("drag\n");
        },
        on_drop      => sub {
            printf("drop\n");
        },
        on_click     => sub {
            printf("click\n");
        },
        on_dblclick  => sub {
            printf("dblclick\n");
        },
        on_mousemove => sub {
        },
        on_keydown   => sub {
            printf("keydown\n");
        },
    };

    while($loop) {
        event_loop($handler);
        if(scalar @{$layers->blit($display)}) {
            $display->flip();
        }
        $fps->delay;
    }
}

sub init_background {

  # Hintergrundbild
  my $background  = SDL::Image::load('data/background.jpg');
  $layers->add(SDLx::Layer->new($background, {id => 'background'}));

  my $empty_stack = SDL::Image::load('data/empty_stack.png');

  # zwei Platzhalter fr Kartenstapel oben links
  $layers->add(SDLx::Layer->new($empty_stack,  20, 20, {id => 'rewind_deck'}));
  $layers->add(SDLx::Layer->new($empty_stack, 130, 20, {id => 'empty_deck'}));

  # sieben Stapel unten
  for(0..6) {
    $layers->add(SDLx::Layer->new($empty_stack, 20+110*$_, 200, {id => 'empty_stack'}));
  }

  # vier Stapel oben rechts
  for(0..3) {
    $empty_target = SDL::Image::load('data/empty_target_' . $_ . '.png');
    $layers->add(SDLx::Layer->new($empty_target, 350+110*$_, 20, {id=>"empty_target_$_"}));
  }
}
