#!/usr/bin/perl

use strict;
use warnings;

use Data::Dumper;

sub take (&$;$){
  my ($c_block,$count,$c_iter_in) = @_;
 
  #-  Nur 2 Args ? => der 2. war Iterator
  unless (defined $c_iter_in) {
    $c_iter_in=$count;
    $count = -1;
  }

  my @collect;
  my $result;
  my $last = 0;
 
  #- Listenkontext?
  if (wantarray) {
    while (1) {
      my $idx_in = $c_iter_in->();
      my @result = $c_block->();
 
      if ( $idx_in and          # nicht fertig 
           @result != 0 )       # nicht leer
        {
          push @collect,@result;
          $count--;
        } 
    
      return @collect unless	  #- Fertig ?
        $count and	          
          $idx_in;	          
    }
  }
 
  #- Scalar oder Void-Kontext?
  else { 
    my $finnish;
 
    #- mache Iterator
    my $c_iter = sub {
      while (1) {
        if ($finnish or $count==0) {         
          return;		  # Leere Liste
        }
 
        unless ($c_iter_in->()) # iterieren
          { $finnish = 1; }     # flag
      
        my @result=$c_block->();
        if ( @result !=0 ) {
          $count--;
          return @result;
        }
      }
    };
    return $c_iter;
  }
}

sub from (&;$$) {
  my $c_block   = shift;        # Block;
  my $s_var	  = \$_[0];       # Laufvariable 
  my $c_iter_in = $_[1];        # IN-Iterator
 
  undef $$s_var;                # reset

  #-- weitere closure Variablen
  my @blocklist;
  my $idx;
  my $idx_in;
 
  my $c_iter = sub {
 
    #-- Initialisierung
    unless ($idx) {             # erster Lauf?
      @blocklist=$c_block->();  #   init Liste
      unless (@blocklist) {     #   leer?
        return;                 #     Abbruch!
      } 
      $idx = 0;                 #   init idx
    }
 
    #-- Zuweisung Listenelemente
    $$s_var=$blocklist[$idx];   

    #-- Innere Schleife fortschalten    
    if ($c_iter_in) {           # vorhanden ?
      $idx_in = $c_iter_in->(); #  fortschalten
      if ($idx_in) {            #  nicht fertig?
        return $idx.$idx_in;    #   concat Index
      }
    }
 
    #-- Inkrementiere Index modulo Listengroesse
    $idx = ($idx+1) % @blocklist; 
 
    return $idx;
  };
 
  return $c_iter;
}

my  @list = take { [$a,$b] } 5 => from {1..10} $a => from {1..$a} $b;

print Dumper \@list;