#!/usr/bin/perl

use strict;
use warnings;
use FindBin;
use Getopt::Long;
use Net::Snarl;
use Win32::TaskScheduler;
use XML::RSS::Parser;
use Data::Dumper;

our $task_name  = 'OReillyFeed';
our $task_app   = 'C:\strawberry\perl\bin\perl.exe';
our $task_param = $FindBin::Bin . '\oreilly_feed.pl -c run';

our $admin_name = 'xxx';
our $admin_pass = 'xxx';

GetOptions(
    'c=s' => \my $command,
);

my %dispatch = (
    run       => \&run,
    install   => \&install_task,
    uninstall => \&uninstall_task,
);

$command ||= 'run';

if ( !exists $dispatch{$command} ) {
    help();
}
else {
    $dispatch{$command}->();
}

sub run {
    
    # read feed
    my $feed_url   = 'http://community.oreilly.de/blog/feed/';
    my $parser     = XML::RSS::Parser->new;
    my $feed       = $parser->parse_uri( $feed_url );
    
    # get item title
    my $title_node = $feed->query( '//item/title' );
    my $title      = $title_node->text_content;
    
    # get item text
    my $text_node  = $feed->query( '//item/description' );
    my $content    = $text_node->text_content;
    
    # show notification
    my $snarl      = Net::Snarl->register( 'Startup feed' );
    $snarl->add_class( 'feed' );
    $snarl->notify( 'feed', $title, $content, 5 );
}

sub install_task {
    my $scheduler = Win32::TaskScheduler->New;

    my %task_config = (
        BeginYear       => 2010,
        BeginMonth      => 8,
        BeginDay        => 1,
        EndYear         => 2201,
        EndMonth        => 8,
        EndDay          => 1,
        StartHour       => 12,
        StartMinute     => 1,
        MinutesDuration => 0,
        TriggerType     => $scheduler->TASK_TIME_TRIGGER_DAILY,
        Type => {
            DaysInterval => 1,
        },
    );
    
    my $has_new_item = $scheduler->NewWorkItem( $task_name, \%task_config );
    if ( $has_new_item == 1 ) {
        my $has_set_name = $scheduler->SetApplicationName( $task_app );
        $scheduler->SetParameters( $task_param );
        
        my $result = $scheduler->SetAccountInformation( 
            $admin_name, 
            $admin_pass,
        );
        
        if ( $has_set_name ) {
            my $return = $scheduler->Save;
            $scheduler->Activate( $task_name ) if $return;
            warn "$return";
        }
    }
}

sub uninstall_task {
    my $scheduler = Win32::TaskScheduler->New;
    my $return    = $scheduler->Delete( $task_name );
}

sub help {
    print <<"";
Usage: $0 -c <command>
  
  Valid commands:
  run       - read rss feed and show notification if needed
  install   - create task in windows taskscheduler
  uninstall - remove task from taskscheduler

    exit;
}