#!/usr/bin/perl

# Starte Garbage Collection wenn Speicher voll
# wird. Wie Listing 10, jedoch mit einem Bulk-Request
# anstatt zwei separater Requests.

use JMX::Jmx4Perl;
use JMX::Jmx4Perl::Request;
use Data::Dumper;

my $j4p = new JMX::Jmx4Perl(url => "http://localhost:8080/j4p");
while (1) { 
    my @resp = $j4p->request(
                             new JMX::Jmx4Perl::Request(READ,"java.lang:type=Memory","HeapMemoryUsage"), 
                             new JMX::Jmx4Perl::Request(EXEC,"java.lang:type=Threading","findDeadlockedThreads")
                            );
    my $memory = $resp[0]->{value};
    my $dead_locked = $resp[1]->{value};
    if ($memory->{used} / $memory->{max} > 0.01 || @$dead_locked) {
        my $thread_dump = $j4p->execute("java.lang:type=Threading", "dumpAllThreads",1,1);
        open(F,">/tmp/thread_dump_".time);
        print F Dumper($thread_dump); }	
    close F;
    sleep(5 * 60);
}
