package Publikation;

use Moose;
use Moose::Util::TypeConstraints;

subtype 'Format' => 
  as 'Str' =>
  where {
      my $format = $_;
      grep {$_ eq $format }qw(A4 A5 Letter)
  };


has published => ( is => 'ro' );
has pages     => ( is => 'ro' );
has title     => ( is => 'ro' );
has available => ( is => 'ro' );
has format    => (
    is       => 'ro',
    default  => 'A4',
    isa      => 'Format',
    trigger  => sub { print "set format" }
);

sub info {
    my ($self) = @_;
    
    return sprintf "%s has %s pages",
        $self->title, $self->pages;
}

sub is_a {
    my ($self) = @_;
    
    return sprintf "%s isa %s",
        $self->title, ref( $self );
}

no Moose;

1;