#!/usr/bin/perl

use strict;
use warnings;

use SVG;

# define some settings
my $image_width  = 180;
my $image_height = 180;

my $svg = SVG->new(
    width  => $image_width,
    height => $image_height,
);

# a section where we define 
# some things in SVG
my $def = $svg->defs(
    id => 'strich_def',
);

$def->line(
    id => 'strich',
    x1 => 0, y1 => 0,
    x2 => 0, y2 => 8,
    'stroke-width' => 2,
    stroke         => 'black',
);

my $g = $def->g(
    id => 's',
);

$g->use(
    -href     => '#strich',
    transform => 'translate(0,-50)',
);

# end def section

# background
$svg->rect(
    x      => -50,
    y      => -50,
    width  => 200,
    height => 200,
    fill   => '#FFF',
);

my $back_g = $svg->g(
    transform => 'translate(51,51)',
);

$back_g->circle(
    cx     => 0,
    cy     => 0,
    r      => 50,
    stroke => '#00F',
    fill   => '#00F',
);

$back_g->circle(
    cx     => 0,
    cy     => 0,
    r      => 47,
    stroke => '#00F',
    fill   => '#EEE',
);

$back_g->use(
    -href     => '#s',
);

for my $i ( 1 .. 11 ) {
    my $t = 30 * $i;
    $back_g->use(
        -href     => '#s',
        transform => "rotate($t)",
    );
}

# hour
$back_g->line(
    id => 'hz',
    x1 => 0, y1 => 0,
    x2 => 0, y2 => -25,
    'stroke-width' => 4,
    stroke    => '#008',
    transform => 'rotate(138)',
);

# minute
$back_g->line(
    id => 'mz',
    x1 => 0, y1 => 0,
    x2 => 0, y2 => -40,
    'stroke-width' => 4,
    stroke    => '#008',
    transform => 'rotate(216)',
);

# second
$back_g->line(
    id => 'sz',
    x1 => 0, y1 => 0,
    x2 => 0, y2 => -45,
    stroke    => '#800',
    transform => 'rotate(282)',
);

$back_g->circle(
    cx     => 0,
    cy     => 0,
    r      => 4,
    fill   => '#800',
);

if ( open my $fh, '>', 'uhr.svg' ) {
    print $fh $svg->xmlify;
}

