#!/usr/bin/perl

use strict;
use warnings;
use DBI;
use Data::Dumper;
use SVG;

# get data from database
my $data   = get_data();

# sort data by type
my @sorted = sort{
    $a->{type} cmp $b->{type}
}@{$data};

# plot bars
my $y       = 5;
my $x       = 10;
my $counter = 1;
my $width   = 20;

my $image_width  = 180;
my $image_height = 170;
my $margin       = 10;

my $svg = SVG->new(
    width  => $image_width,
    height => $image_height,
);

for my $info ( @sorted ) {
    my $height = int ( $info->{sum} / 5 );
    my $real_y = $image_height - $margin - $height;
    
    $svg->rect(
        x      => $x,
        y      => $real_y,
        id     => 'rect_' . $counter,
        width  => $width,
        height => $height,
    );
    
    $svg->text(
        id => 'sum_' . $counter,
        x  => $x,
        y  => $real_y - 8,
    )->cdata( $info->{sum} );
    
    my $ly = $real_y - 29;
    my $lx = $x + 14;
    
    my $t = "translate($lx,$ly) rotate(-90)";
    
    $svg->text(
        id        => 'type_' . $counter,
        transform => $t,
        -cdata    => $info->{type},
    );
    
    $counter++;
    
    $x += $width + 10;
}

if ( open my $fh, '>', 'basic_chart.svg' ) {
    print $fh $svg->xmlify;
}

print "done...";

sub get_data {
    my $dbh  = DBI->connect( 'DBI:CSV:','','' );
    $dbh->{RaiseError} = 1;
    
    my $sth  = $dbh->prepare( 'SELECT article, SUM(anzahl) FROM svgtest GROUP BY article' );
    $sth->execute;
    
    my @data;
    
    while( my ($type,$sum) = $sth->fetchrow_array ) {
        push @data, { type => $type, sum => $sum };
    }
    
    return \@data;
}