#!/usr/bin/perl

use strict;
use warnings;
use DBI;
use Data::Dumper;

my $data = get_data();
print Dumper $data;

sub get_data {
    my $dbh  = DBI->connect( 'DBI:CSV:','','' );
    $dbh->{RaiseError} = 1;
    
    my $sth  = $dbh->prepare( 'SELECT article, SUM(anzahl) FROM svgtest GROUP BY article' );
    $sth->execute;
    
    my @data;
    
    while( my ($type,$sum) = $sth->fetchrow_array ) {
        push @data, { type => $type, sum => $sum };
    }
    
    return \@data;
}