#!/usr/bin/perl

use strict;
use warnings;
use DBI;
use SVG::TT::Graph::Pie;

# get data from database
my $data   = get_data();

# sort data by type
my @sorted = sort{
    $a->{type} cmp $b->{type}
}@{$data};

my @fields = map{ $_->{type} }@sorted;
my @sales  = map{ $_->{sum}  }@sorted;

use Data::Dumper;
print Dumper [ \@fields, \@sales ];

my $graph = SVG::TT::Graph::Pie->new({
  'height' => '500',
  'width'  => '300',
  'fields' => \@fields,
});

$graph->compress(0);

$graph->add_data({
  'data'  => \@sales,
  'title' => 'Sales 2010',
});

print $graph->compress;
if ( open my $fh, '>', 'pie.svg' ) {
    print $fh $graph->burn();
}

sub get_data {
    my $dbh  = DBI->connect( 'DBI:CSV:','','' );
    $dbh->{RaiseError} = 1;
    
    my $sth  = $dbh->prepare( 'SELECT article, SUM(anzahl) FROM svgtest GROUP BY article' );
    $sth->execute;
    
    my @data;
    
    while( my ($type,$sum) = $sth->fetchrow_array ) {
        push @data, { type => $type, sum => $sum };
    }
    
    return \@data;
}