#!/usr/bin/perl

use strict;
use warnings;

use SVG::Rasterize;
use SVG::Parser;

my $file = 'easy.svg';

my $svg = do{
    local (@ARGV,$/) = $file;
    <>
};

$svg =~ s{ <!-- .*? --> }{}xmsg;

my $parser = SVG::Parser->new;
my $dom    = $parser->parse( $svg );

my $rasterizer = SVG::Rasterize->new;
$rasterizer->rasterize(
    svg => $dom,
);
$rasterizer->write(
    type      => 'png',
    file_name => 'easy_graph.png',
);
