#!/usr/bin/perl

use strict;
use warnings;

use DBI;
use HTTP::Daemon;
use HTTP::Status;
use HTTP::Response;
use JSON::Syck;
use SVG;
use SVG::Parser;
use SVG::TT::Graph::Pie;


my $d = HTTP::Daemon->new( LocalPort => 8088 ) || die;
print "Please contact me at: <URL:", $d->url, ">\n";
while(my $c = $d->accept)
{
    while ( my $r = $c->get_request ) {
        my $path = $r->uri->path;
        if ( $path eq '/mychart.svg' ) {
            my $svg = create_chart();
            $c->send_response(
                HTTP::Response->new(
                    200, 'OK', [ 'Content-Type' => 'image/svg+xml' ],
                    $svg,
                ),
            );
        }
        elsif ( $path eq '/chart.cgi' ) {
            my $params = $r->url->query;
            my ($nr) = $params =~ m{ nr=([0-9]+) }xms;
            warn ">>$params -> $nr<<";
            $nr ||= 1;
            $c->send_response(
                HTTP::Response->new(
                    200, 'OK', [ 'Content-Type'=>'application/json'],
                    JSON::Syck::Dump( get_details($nr) )
                )
            );
        }
        else {
            $c->send_error(RC_FORBIDDEN)
        }
    }
    $c->close;
    undef($c);
}

sub create_chart {
    # get data from database
    my $sorted   = get_data();

    my @fields = map{ $_->{type} }@{$sorted};
    my @sales  = map{ $_->{sum}  }@{$sorted};

    my $graph = SVG::TT::Graph::Pie->new({
      'height' => '500',
      'width'  => '300',
      'fields' => \@fields,
    });

    $graph->compress(0);

    $graph->add_data({
      'data'  => \@sales,
      'title' => 'Sales 2010',
    });
    
    my $parser = SVG::Parser->new;
    my $dom    = $parser->parse( $graph->burn );

    # find all parts of the cake
    my @paths = $dom->getElements( 'path' );

    PATH:
    for my $path ( @paths ) {
        my $id = $path->getElementID;
        
        my ($nr) = $id =~ m{ \A w (\d+) }xms;
        
        next PATH if !$nr;
        
        $path->setAttributes({
            onclick => "show_months($nr);",
        });
    }
    
    $dom->text(
        id => 'monatszahlen',
        x  => 20,
        y  => 20,
    )->cdata('Uebersicht');

    $dom->script(
        type   => 'text/javascript',
        -cdata => qq~         
     function parse_response()
     {
        if(xmlhttp.readyState == 4)
        {
            if(xmlhttp.status == 200)
            {
                var textelement = document.getElementById( 'monatszahlen' );
                var data = JSON.parse( xmlhttp.responseText );
                
                textelement.firstChild.nodeValue = data;
            }
        }
     }

     var xmlhttp;

     function show_months(nr)
     {
        xmlhttp = new XMLHttpRequest();
        xmlhttp.onreadystatechange = parse_response;
        
        // Make an HTTP request to get input to the system.
        if(xmlhttp !== null)
        {
            xmlhttp.open( 'GET', "/chart.cgi?nr="+nr, true );
            xmlhttp.send( '' );
        }
     }
        ~,
    );

    return $dom->xmlify;
}

sub get_details {
    my ($index) = @_;
    
    my $dbh  = DBI->connect( 'DBI:CSV:','','' );
    $dbh->{RaiseError} = 1;
    
    my $sth_titles = $dbh->prepare( 'SELECT DISTINCT article FROM svgtest ORDER BY article' );
    $sth_titles->execute();
    
    my @articles;
    while ( my ($article) = $sth_titles->fetchrow_array ) {
        push @articles,$article;
    }
    
    my $where = $articles[$index-1];
    
    return $where;
}

sub get_data {
    my $dbh  = DBI->connect( 'DBI:CSV:','','' );
    $dbh->{RaiseError} = 1;
    
    my $sth  = $dbh->prepare( 'SELECT article, SUM(anzahl) FROM svgtest GROUP BY article' );
    $sth->execute;
    
    my @data;
    
    while( my ($type,$sum) = $sth->fetchrow_array ) {
        push @data, { type => $type, sum => $sum };
    }
    
    my @sorted = sort{
        $a->{type} cmp $b->{type}
    }@data;
    
    return \@sorted;
}