#!/usr/bin/perl

use strict;
use warnings;

use SVG::Parser;

my $file = 'pie.svg';

my $parser = SVG::Parser->new;
my $dom    = $parser->parse_file( $file );

# find all parts of the cake
my @paths = $dom->getElements( 'path' );

PATH:
for my $path ( @paths ) {
    my $id = $path->getElementID;
    
    my ($nr) = $id =~ m{ \A w (\d+) }xms;
    
    next PATH if !$nr;
    
    $path->setAttributes({
        onclick => "change_values($nr);",
    });
}

$dom->script(
    type   => 'text/javascript',
    -cdata => qq~
    function change_values(nr) {
        var textelement = document.getElementById( 'd' + nr );
        var percent     = nr * 3;
        textelement.firstChild.nodeValue = percent + '%';
    }
    ~,
);

if ( open my $fh, '>', 'pie_enhanced.svg' ) {
    print $fh $dom->xmlify;
}

# add javascript that calls the server and displays the text
