#!/usr/bin/perl

use strict;
use warnings;

use Algorithm::CheckDigits;

my $isbn = '978-3-423-24787-0';
my $visa = '4111 1111 1111 1111';

my $isbn_obj = CheckDigits( 'ISBN13' );
my $visa_obj = CheckDigits( 'visa' );

if (
    $isbn_obj->is_valid( $isbn ) &&
    $visa_obj->is_valid( $visa ) ) {
    print "Sie haben das Buch gekauft...\n";
}