package Publikation;

use Moose;

has title    => ( is => 'ro' );
has format   => ( is => 'rw' );
has articles => (
    traits     => ['Array'],
    is         => 'rw',
    isa        => 'ArrayRef[Str]',
    auto_deref => 1,
    handles    => {
        add_article => 'push',
    },
    default    => sub{ [] },
);

sub publish {
    my ($self) = @_;
    
    for my $article ( $self->articles ) {
        print "füge $article in ausgabe",
              "datei hinzu...\n";
    }
}

no Moose;

1;