#!/usr/bin/env perl

use strict;
use Coro::State;

{
  my $current=new Coro::State;
  my $retv;

  sub take ($) {
    $retv=$_[0];
    my $coro=$current;
    $current=$coro->{caller};
    $coro->transfer($current);
  }

  sub gather (&@) {
    my ($fn, @param)=@_;
    my $coro=new Coro::State sub {
      $fn->(@_);
      $current->cancel;
      take undef;
    }, @param;
    $coro->{caller}=$current;
    return sub {
      return if $coro->is_destroyed;
      my $tmp=$current;
      $current=$coro;
      $tmp->transfer($current);
      return if $coro->is_destroyed;
      return $retv;
    };
  }
}

sub take_if_odd {
  take $_ if $_ % 2;
}

my $it=gather {
  take_if_odd for (11..20);

  take "===============";

  my $it=gather {
    my $i=$_[0];
    ($i % 3 || take $i, $i++) while 1;
  } 99;

  $_=$it->();
  (take_if_odd, $_=$it->()) while 1;
};

print $it->(), "\n" for 1..20;
