#!/usr/bin/perl

use strict;
use warnings;

use MethodOriginTest;
use GraphViz;

my $gv    = GraphViz->new;
my $start = 'MethodOriginTest';

$gv->add_node( $start );

find_parents_and_roles( 'MethodOriginTest', $gv );

sub find_parents_and_roles {
    my ($name,$gv) = @_;

    return if $name =~ m{ \A (?:Moose|Method) :: }xms;

    my $meta    = $name->meta;

    if ( $meta->can( 'superclasses' ) ) {
        my @parents = $meta->superclasses;
        if ( @parents ) {
            for my $parent ( @parents ) {
                $gv->add_node( $parent );
                $gv->add_edge(
                    $name => $parent,
                    dir   => 'forward',
                );
                find_parents_and_roles( $parent, $gv );
            }
        }
    }

    if ( $meta->can( 'roles' ) ) {
        my @roles   = @{ $meta->roles || [] };

        if ( @roles ) {
            for my $role ( @roles ) {
                $gv->add_node( $role->name );
                $gv->add_edge(
                    $name => $role->name,
                    dir   => 'none',
                );
                find_parents_and_roles( $role->name, $gv );
            }
        }
    }
}

open my $img, '>', 'test.png' or die $!;
binmode $img;
print $img $gv->as_png;
close $img;

