#!/usr/bin/perl -w

use strict;
use Data::Dumper;
use OpenGL qw(:glfunctions :glconstants :glufunctions :gluconstants);
use OpenGL::Simple::GLUT qw(:all);

my $TimerCallsPerSecond = 30;

my $BallPosition = [250,250];
my $BallVelocity = [0.1,0.1];

my $Player1Y = 100;
my $Player2Y = 300;

main();

sub main
{
	glutInit();
	glutInitDisplayMode(GLUT_DOUBLE | GLUT_RGB | GLUT_DEPTH);
	glutInitWindowSize(500, 500);
	glutCreateWindow("Pong");
	
	glutDisplayFunc(\&display);
	glutReshapeFunc(\&reshape);

	glutTimerFunc(int(1000 / $TimerCallsPerSecond), \&timer, 0);
	#glutKeyboardFunc(\&keyboard);
	glutSpecialFunc(\&keyboard);

	glEnable(GL_DEPTH_TEST);
  glClearColor(1,1,1,1);
	
	glutMainLoop();
}

	sub keyboard {
		my ($key, $x, $y) = @_;
		if ($key == 101) {
			$Player1Y = clip($Player1Y + 10, 20, 430);
		}
		elsif ($key == 103) {
			$Player1Y = clip($Player1Y - 10, 20, 430);
		}
	}

	sub timer {
 		my ($lastCallTime) = @_;
    my $thisCallTime = glutGet(GLUT_ELAPSED_TIME);
    my $delta_t = $thisCallTime - $lastCallTime;
    $BallPosition = [
    	$BallVelocity->[0] * $delta_t + $BallPosition->[0],
    	$BallVelocity->[1] * $delta_t + $BallPosition->[1],    
    ];
		glutTimerFunc(int(1000 / $TimerCallsPerSecond), \&timer, $thisCallTime);
		glutPostRedisplay();
	}

sub reshape
{
	my ($w, $h) = @_;
	glViewport(0,0, $w, $h);

  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  glOrtho(
  	0, $w, 0, $h, # left right bottom top
 		-10.0, 10.0, # near far
  );
}

sub grid
{
	glBegin(GL_LINE_LOOP);
		glColor3f(0.3,0.3,0.3);
		glVertex3f(0,1,0);
		glVertex3f(0,0,0); 
		glVertex3f(1,0,0);
		glVertex3f(1,1,0);
	glEnd();
}

sub ball
{
	my $segments = 16;
	my @verts = ();
	foreach my $a (0..$segments) {
		my $angle = $a * (360/$segments);
		push @verts, [sin($angle*3.1415/180), cos($angle*3.1415/180)];
	}
	
	glBegin(GL_TRIANGLE_FAN);
		glColor3f(0.5,0.8,1);
		glVertex3f(-0.2, 0.2, 0);
		
		glColor3f(0.3,0.6,0.8);
		map { glVertex3f(@{$_}, 0) } @verts;
	glEnd();
}

  sub clip {
    my ($value, $min, $max) = @_;
    return ($value < $min ? $min : ($value > $max ? $max : $value));
  }

 sub player {
 	my @red = (1,0,0);
 	my @lightRed = (1,0.8,0.8);
   glBegin(GL_QUADS);
     glColor3f(@red);
     glVertex3f(0,1,0);
 
     glColor3f(@red);
     glVertex3f(0,0,0); 
 
     glColor3f(@lightRed);
     glVertex3f(1,0,0);
 
     glColor3f(@lightRed);
     glVertex3f(1,1,0);
   glEnd();
 }

sub display
{
  glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

  glMatrixMode(GL_MODELVIEW);
  glLoadIdentity();
  
  gluLookAt(
  	0.0, 0.0, 2.0, # eye pos
    0.0, 0.0, 0.0, # center pos
    0.0, 1.0, 0.0  # up vector
  ); 

	draw();

  glutSwapBuffers();
}

 sub draw {
   # Ball
   glPushMatrix();
     glTranslatef($BallPosition->[0], $BallPosition->[1], 0);
     glScalef(10, 10, 1);
     ball();
   glPopMatrix();
 
   # Spieler 1
   glPushMatrix();
     glTranslatef(20, $Player1Y, 0);
     glScalef(20, 50, 1);
     player();
   glPopMatrix();
 
   # Spieler 2
   glPushMatrix();
     glTranslatef(460, 300, 0);
     glScalef(20, 50, 1);
     player();
   glPopMatrix();
 }
