package Role::Basic::MethodModifier;

use strict;
#use warnings;

use Role::Basic;
use Hook::LexWrap;
use base 'Exporter';

our @EXPORT = qw(before after);

my %subs;
my %modified;

sub before {
    my ($name,$sub) = @_;
    
    my $caller = caller();
    $subs{"pre::${caller}::$name"} = $sub;
}

sub after {
    my ($name,$sub) = @_;
    
    my $caller = caller();
    $subs{"post::${caller}::$name"} = $sub;
}

no strict 'refs';

sub _getglob {
    \*{ $_[0] }
}

wrap *{ _getglob('Role::Basic::_add_role_methods_to_target')}, post => sub {
    my ( $class, $role, $target ) = @_;
    
    for my $modified ( keys %subs ) {
        
        my $key = join '::', $modified, $target;
        next if $modified{$key};
        
        next if $modified !~ m{ \A (?:pre|post) :: $role :: }x;
        
        my $method = (split /::/, $modified)[-1];
        next if not $target->can( $method );
        
        my ($type) = split /::/, $modified;
        
        wrap *{ _getglob "${target}::$method" },
            $type => $subs{$modified};
            
        $modified{$key} = 1;
    }
};

1;