#!/usr/bin/perl

use strict;
use warnings;

use Parse::BBCode;

my $text = 'Ich will so ein Magazin:
[url]http://perl-magazin.de[/url].
[perl]$foo[/perl]
[magic]$bar[/magic]';

my $parser = Parse::BBCode->new({
    tags => {
        Parse::BBCode::HTML->defaults,
        perl  => '<pre>%s</pre>',
        magic => '<pre>%{euro}s</pre>',
    },
    escapes => {
        Parse::BBCode::HTML->default_escapes,
        euro => sub{
            my ($parser, $tag, $text) = @_;
            $text =~ s/\$/\x{20ac}/g;
            return $text;
        },
    },
});

print $parser->render( $text );
__END__
Ich will so ein Magazin:<br>
<a href="http://perl-magazin.de" rel="nofollow">http://perl-magazin.de</a>.<br>
<pre>$foo</pre><br>
<pre>€bar</pre>