#!/usr/bin/perl

use strict;
use warnings;

use HTTP::BrowserDetect;

my $browser_string = "Mozilla/5.0 (iPad; U; CPU OS 4_3_4 like Mac OS X; en-us) AppleWebKit/533.17.9 (KHTML, like Gecko) Version/5.0.2 Mobile/8K2 Safari/6533.18.5";
my $browser = HTTP::BrowserDetect->new( $browser_string );

for my $type ( qw(ie firefox safari mac windows) ) {
    printf "%s: %s\n", $type, $browser->$type();
}

for my $level (qw(version major minor)) {
    my $method = 'public_' . $level;
    printf "Version $level: %s\n", $browser->$method();
}
__END__
ie: 
Use of uninitialized value in printf at browser_detect.pl line 11.
firefox: 
safari: 1
mac: 
windows: 
Version version: 5
Version major: 5
Version minor: .0