#!/usr/bin/perl

use strict;
use warnings;

use File::Queue;
 
my $fq = File::Queue->new(
    path   => '/tmp/emails',
    mkpath => 1
);

# Create a message
my $message = Email::Simple->create(...);

# Schedule the message 50 times (for the sake of the example)
$fq->schedule($message) for ( 0 .. 49 );

# ... much later ... from another script ....
 
# Process the scheduled messages
while ( my $message = $fq->next ) {
 
    # sendmail is an imaginery sub that sends RFC2822 formatted emails.
    sendmail( $message->as_string );
}