#!/usr/bin/perl 
use warnings;
use strict;

use SNMP::Info;

my $desthost  = '10.0.0.1';
my $community = 'public';

my $info = new SNMP::Info(

  # Auto Discover more specific Device Class
  AutoSpecify => 1,
  Debug       => 0,

  # The rest is passed to SNMP::Session
  DestHost    => $desthost,
  Community   => $community,
  Version     => 1,
) or die "Can't connect to $desthost!\n";

print "Connected to $desthost.\n";

my $interfaces = $info->interfaces();

# Get CDP Neighbor info

# Returns the mapping
# to the SNMP Interface Table
my $c_if   = $info->c_if();

# returns remote IPV4 address
my $c_ip   = $info->c_ip();

# Returns remote port ID
my $c_port = $info->c_port();

# Print out data per port
foreach my $iid ( keys %$interfaces ) {

  # Print out physical port name,
  # not snmp iid
  my $port = $interfaces->{$iid};

  # The CDP Table has table entries
  # different than the interface
  # tables.
  # So we use c_if to get the map
  # from cdp table to interface
  # table.

  my %c_map = reverse %$c_if;
  my $c_key = $c_map{$iid};
  unless ( defined $c_key ) {
    next;
  }
  my $neighbor_ip   = $c_ip->{$c_key};
  my $neighbor_port = $c_port->{$c_key};

  if ( defined $neighbor_ip ) {
    print "Local port '$port'
          connected to '$neighbor_ip'
          remote port '$neighbor_port'\n";
  }
}