#!/usr/bin/perl

use strict;
use warnings;

use IO::File;
use SVG::Sparkline;
use Sys::Statistics::Linux::LoadAVG;

my @values;
my $counter = 1;

my $stats = Sys::Statistics::Linux::LoadAVG->new;
while ( 1 ) {
     my $load = $stats->get;
     push @values, [ $counter, $load->{avg_1} ];
     
     $counter++;
     last if $counter == 10;
     sleep 30;
}


my $svg = SVG::Sparkline->new(
    Line => {
        values => \@values,
        color  => 'black',
        height => 12,
        mark   => [ high => 'red' ],
    }
);

my $fh = IO::File->new( 'test.svg', 'w' );
$fh->print( $svg->to_string );
$fh->close;
