#!/usr/bin/perl

use strict;
use warnings;
use X11::WindowHierarchy;
 
# Returns a list of all windows with at least one 'word' character in the
# window title, using the current $ENV{DISPLAY} to select the display and
# screen
my @windows = x11_filter_hierarchy(
   filter => qr/\w/
);
printf "Found window [%s] (id %d)%s\n", $_->{title}, $_->{id}, $_->{pid} ? ' pid ' . $_->{pid} : '' for @windows;
 
# Dump all information we have about all windows on display :1
use Data::TreeDumper;
print DumpTree(x11_hierarchy(display => ':0'));
