package Magazin;

use strict;
use warnings;

use Moose;
use Moose::Util::TypeConstraints;
use Carp;

use DateTime;

subtype 'DateTime' => 
   as 'Object' => 
   where { $_->isa('DateTime') };

coerce 'DateTime' =>
   from 'Str' =>
   via {
     my %params;
     @params{qw/day month year/} = split /\./, $_;
     my $obj = DateTime->new( %params );
     $obj;
   };

use overload (
  '""'       => 'print_title',
  '+'        => \&add,
  '<=>'      => \&compare,
  'bool'     => 'bool',
  'nomethod' => sub { croak 'no valid operation' },
);

has title     => ( isa => 'Str', is => 'ro' );
has date      => ( isa => 'DateTime', is => 'ro', coerce => 1 );
has published => ( isa => 'Bool', is => 'ro' );

sub add {
    my ($self,$value,$swap) = @_;

    my $date = $self->date->clone;
    $date->add( months => $value * 3 );
    return $date->dmy( '.' );
}

sub print_title {
    return shift->title;
}

sub bool {  shift->published }

no Moose;

1;
