package FooKalender;

use strict;
use warnings;
use base qw(CGI::Application);
use Kalender::Month;
use Kalender::DB;

sub setup{
    my ($self)  = @_;

    $self->template( './kalender.tmpl' );
    $self->action( '/index.cgi' );
    $self->db( Kalender::DB->new() );
    $self->kalender( Kalender::Month->new() );

    $self->start_mode( 'show_today' );
    $self->mode_param( 'action' );

    $self->run_modes(AUTOLOAD   => \&show_today,
                     day        => \&show_day,
                     insert     => \&insert_date,
                     show       => \&show_date,
                     edit       => \&edit_date,
                     update     => \&update_date,
                     add        => \&add_date,
                     delete     => \&delete_date,
                     month      => \&show_dmonth,);
}

sub cgiapp_prerun{
    my ($self)   = @_;

    my $rm       = $self->get_current_runmode;
    if( $rm eq 'day' or
        $rm eq 'insert' or
        $rm eq 'update' ){

        my %params = $self->query->Vars;
        if( $params{day} >= 1 and $params{day} <= 31 ){
            warn "Tagesangabe ist in Ordnung\n";
        }
    }
}