package Kalender;

use strict;
use warnings;
use Kalender::Month;
use Kalender::DB;
use lib qw(/homes/frasbio11/reneeb/cpan/);
use base ('CGI::Application::Plugin::HTCompiled','CGI::Application');

sub cgiapp_prerun{
    my ($self)   = @_;
    
    my $rm       = $self->get_current_runmode;
}

sub cgiapp_postrun{
    my ($self)   = @_;
    $self->db->end;
}

sub setup{
    my ($self)  = @_;
    
    $self->template( './kalender.tmpl' );
    $self->action( 'http://frasdat110/protein_modification-cgi/test/base.cgi' );
    $self->db( Kalender::DB->new() );
    $self->kalender( Kalender::Month->new() );
    
    $self->start_mode( 'show_today' );
    $self->mode_param( 'action' );
    
    $self->run_modes(AUTOLOAD   => \&show_today,
                     day        => \&show_day,
                     insert     => \&insert_date,
		     show       => \&show_date,
		     edit       => \&edit_date,
		     update     => \&update_date,
		     add        => \&add_date,
		     delete     => \&delete_date,
		     month      => \&show_dmonth,);
}

sub show_month{
    my ($self,$month,$year) = @_;
    
    my @array = map{ {WEEK => $_} }$self->kalender->get_month( 
              $self->db->get_days($month,$year), 
	      $month, 
	      $year );
}

sub show_dmonth{
    my ($self) = @_;
    
    my %params = $self->query->Vars;
    
    return $self->show_day( 1, @params{qw/month year/} );
}

sub show_today{
    my ($self) = @_;
    
    my ($d,$m,$y) = (localtime time)[3..5];
    ++$m;
    $y += 1900;
    
    my @calendar = $self->show_month( $m,$y );
    my @dates    = $self->db->get_ids( $d,$m,$y );
    
    my $month_var= sprintf "%02d/%04d",$m,$y;
    
    my $monthmm  = $m ==  1 ? 12 : $m-1;
    my $yearmm   = $m ==  1 ? $y-1 : $y;
    
    my $monthpp  = $m == 12 ?  1 : $m+1;
    my $yearpp   = $m == 12 ? $y+1 : $y;
    
    return $self->do_template({
                    MONTHMM  => $monthmm,
                    YEARMM   => $yearmm,
                    MONTHPP  => $monthpp,
                    YEARPP   => $yearpp,
                    MONTHVAR => $month_var,
                    KALENDER => \@calendar,
		    DATES    => \@dates,});
}

sub show_day{
    my ($self,$day,$month,$year) = @_;
    
    my %params   = $self->query->Vars;
    $day       ||= $params{day};
    $month     ||= $params{month};
    $year      ||= $params{year};
    
    my @calendar = $self->show_month( $month,$year );
    my @dates    = $self->db->get_ids( $day,$month,$year );
    
    my $month_var= sprintf "%02d/%04d",$month,$year;
    
    my $monthmm  = ($month ==  1) ? 12 : $month-1;
    my $yearmm   = ($month ==  1) ? $year-1 : $year;
    
    my $monthpp  = ($month == 12) ?  1 : $month+1;
    my $yearpp   = ($month == 12) ? $year+1 : $year;
    
    return $self->do_template({
                    MONTHMM  => $monthmm,
                    YEARMM   => $yearmm,
                    MONTHPP  => $monthpp,
                    YEARPP   => $yearpp,
                    MONTHVAR => $month_var,
                    KALENDER => \@calendar,
		    DATES    => \@dates,});
}

sub show_date{
    my ($self) = @_;
    
    my %params = $self->query->Vars;
    my @info   = $self->db->get_date( $params{id} );

    my %hash;
    @hash{qw/ID DAY MONTH YEAR TITLE DESC/} = @info;
    
    return $self->do_template(
                    \%hash,
		    './date.tmpl',);
}

sub edit_date{
    my ($self) = @_;
    
    my %params = $self->query->Vars;
    my @info   = $self->db->get_date( $params{id} );

    my %hash = (RUNMODE => 'update');
    @hash{qw/ID DAY MONTH YEAR TITLE DESC/} = @info;
    
    return $self->add_date( %hash );
    
}

sub update_date{
    my ($self) = @_;
    
    my %params = $self->query->Vars;
    my @info   = @params{qw/id day month year title desc/};
    
    $self->db->update_date( @info );
    return $self->show_date;
}

sub add_date{
    my ($self,%hash) = @_;
    
    $hash{RUNMODE} = 'insert' unless exists $hash{RUNMODE};
    
    return $self->do_template(
                    \%hash,
                    './add_date.tmpl',);
}

sub insert_date{
    my ($self) = @_;
    
    my %params = $self->query->Vars;
    
    $self->db->insert_date( @params{qw/day month year title desc/} );
    return $self->show_day( @params{qw/day month year/} );
}

sub delete_date{
    my ($self) = @_;
    
    my %params = $self->query->Vars;
    my @info   = $self->db->get_date( $params{id} );
    $self->db->delete_date( $params{id} );
    return $self->show_day( @info[1..3] );
}

sub do_template{
    my ($self,$hash,$tmpl) = @_;
    
    $tmpl ||= $self->template;
    
    my $template = $self->load_tmpl( $tmpl );
    $template->param( %$hash );
    return $template->output;
}

sub db{
    my ($self,$obj) = @_;
    
    $self->{db} = $obj if defined $obj;
    
    return $self->{db};
}

sub kalender{
    my ($self,$obj) = @_;
    
    $self->{kalender} = $obj if defined $obj;
    
    return $self->{kalender}; 
}

sub template{
    my ($self,$obj) = @_;
    
    $self->{template} = $obj if defined $obj;
    
    return $self->{template};
}

sub action{
    my ($self,$obj) = @_;
    
    $self->{action} = $obj if defined $obj;
    
    return $self->{action};
}

1;
