package Kalender::DB;

use strict;
use warnings;

use DBI;

sub new{
    my ($class) = @_;
    my $self = {};
    bless $self,$class;
    
    $self->dbh( DBI->connect("DBI:mysql:ProFIT:frasdat110","rene","ReNe002") ); 
    
=pod
    my $st = q~CREATE TABLE dates( 
        id    INT NOT NULL PRIMARY KEY,
        day   INT,
	month INT,
	year  INT,
	title VARCHAR(255),
	descr VARCHAR(255)
	)
    ~;
    $self->dbh->do($st);
=cut
    
    return $self;
}

sub dbh{
    my ($self,$obj) = @_;
    
    $self->{dbh} = $obj if defined $obj;
    
    return $self->{dbh};
}

sub end{
    shift->dbh->disconnect();
}

sub get_days{
    my ($self,$month,$year) = @_;
    
    my $stmt = "SELECT day FROM dates WHERE month = ? AND year = ?";
    my $sth  = $self->dbh->prepare($stmt);
    $sth->execute($month,$year);
    
    my @dates = map{ $_->[0] }@{$sth->fetchall_arrayref};
    
    $sth->finish();
    
    return join(";",@dates);
}

sub update_date{
    my ($self,$id,@values) = @_;
    
    my $stmt   = q~UPDATE dates 
                          SET day = ?, month = ?, year = ?, title = ?, descr = ? 
			  WHERE id = ?~;
    $self->dbh->do($stmt,undef,@values,$id);
}

sub delete_date{
    my ($self,$id) = @_;
    
    my $stmt   = "DELETE FROM dates WHERE id = ?";
    $self->dbh->do($stmt,undef,$id);
}

sub insert_date{
    my ($self,@values) = @_;
    
    my $st_id  = "SELECT MAX(id) FROM dates";
    my $sth_id = $self->dbh->prepare($st_id) or die $self->dbh->errstr;
    $sth_id->execute() or die $self->dbh->errstr;
    my ($id)   = $sth_id->fetchrow_array(); 
    
    $sth_id->finish();
    
    my $stmt   = "INSERT INTO dates VALUES(?,?,?,?,?,?)";
    $self->dbh->do($stmt,undef,++$id,@values) or die $self->dbh->errstr;
}

sub get_date{
    my ($self,$id) = @_;
    
    my $stmt = "SELECT * FROM dates WHERE id = ?";
    my $sth  = $self->dbh->prepare($stmt);
    $sth->execute($id);
    my @row  = $sth->fetchrow_array();
    $sth->finish();
    
    return @row;
}

sub get_ids{
    my ($self,@dates) = @_;
    
    my $stmt = "SELECT id,title FROM dates WHERE day = ? AND month = ? AND year = ?";
    my $sth  = $self->dbh->prepare($stmt);
    $sth->execute(@dates);
    
    my @ids  = map{ {ID => $_->[0], TITLE => $_->[1] } }@{$sth->fetchall_arrayref};
    
    $sth->finish();
    
    return @ids;
}

1;
