package Kalender::Month;

use strict;
use warnings;

use Data::Tabulate;
use Time::Local;

my %cache;

use Data::Dumper;

sub new{
    my ($class) = @_;
    my $self    = {};
    
    bless $self,$class;
    
    $self->_tabulator;
    
    $self->_tabulator->min_columns(7);
    $self->_tabulator->max_columns(7);
    
    return $self;
}

sub get_month{
    my ($self,$datestr,$month,$year) = @_;
    
    $month = (localtime time)[4] +    1 unless $month;
    $year  = (localtime time)[5] + 1900 unless $year;
    
    my @dates = split /;/,$datestr;
    my @days;
    
    for my $day( 1..$self->_get_days($month,$year) ){
        my $bool = grep{ $day eq $_ }@dates;
	push @days, { VALUE => $day, BOOL => $bool, MONTH => $month, YEAR => $year };
    }
    
    @days = $self->_fill_array($month,$year,@days);
    @days = $self->_tabulator()->tabulate(@days);
    
    return @days;
}

sub _fill_array{
    my ($self,$month,$year,@array) = @_;
    
    my $time   = timelocal(0,0,0,1,$month-1,$year-1900);
    my $wday   = (localtime $time)[6];
    $wday      = 7 if $wday == 0;
    
    my @undefs = (undef) x ($wday-1);
    
    return @undefs,@array;
}

sub _get_days{
    my ($self,$month,$year) = @_;
    
    $year = (localtime time)[5] + 1900 unless $year;
    
    my %days = ('01' => 31, '02' => 28, '03' => 31, '04' => 30,
                '05' => 31, '06' => 30, '07' => 31, '08' => 31,
                '09' => 30, '10' => 31, '11' => 30, '12' => 31,);
    
    if( $month == 2 ){
        unless( exists $cache{$year} ){ 
            $cache{$year} = $self->_is_leap_year($year);
        }
	
	$days{'02'} = 29 if( $cache{$year} );
    }
    
    return $days{sprintf "%02d",$month};
}

sub _is_leap_year{
    my ($self,$year) = @_;
    
    if( $year % 400 == 0 ){
        return 1;
    }
    elsif( ($year % 4 == 0) and ($year % 100 != 0) ){
        return 1;
    }
    
    return 0;
}

sub _tabulator{
    my ($self) = @_;
    
    unless( exists $self->{tabulator} ){
        $self->{tabulator} = Data::Tabulate->new();
    }
    
    return $self->{tabulator};
}

1;


