#!/usr/bin/perl

use strict;
use warnings;
use Kalender::Month;
use Test::More tests => 14;
use Data::Dumper;

my $calendar = Kalender::Month->new();

my @pos = (1996, 2000, 1904, 4);
my @neg = (3000, 1900, 1901, 2007, 6);

for(@pos){
  is($calendar->_is_leap_year($_), 1, "Tested: $_");
}

for(@neg){
  is($calendar->_is_leap_year($_), 0, "Tested: $_");
}

my @check = ([3,2007,31], [2,2000,29], [2,2009,28]);
for(@check){
    my ($month,$year,$days) = @$_;
    is($calendar->_get_days($month,$year),$days,"Check: $month/$year");
}

for([1,31],[2,28]){
    my ($month,$days) = @$_;
    is($calendar->_get_days($month),$days,"Check: $month");
}

my $datestr = "3;19;20;28";
my $month   = 3;
my $year    = 1999;

my @result  = $calendar->get_month($datestr,$month,$year);
print Dumper(\@result);
