#!/usr/bin/perl

use strict;
use warnings;

use XML::RSS::FromHTML::Simple;

my $proc = XML::RSS::FromHTML::Simple->new({
url => "http://use.perl.org/~reneeb",
rss_file => "new_comments.xml",
});

$proc->link_filter( sub {
    my($link, $text) = @_;

    # Only extract links that contain 'comments.pl'
    # in their URL
    if( $link =~ m#comments\.pl#) {
        return 1;
    } else {
        return 0;
    }
});

# Create RSS file
$proc->make_rss() or die $proc->error();