package PerlFAQ::Controller::FAQ;

use strict;
use warnings;
use base 'Catalyst::Controller';

use Data::Dumper;

=head1 NAME

PerlFAQ::Controller::FAQ - Catalyst Controller

=head1 SYNOPSIS

See L<PerlFAQ>

=head1 DESCRIPTION

Catalyst Controller.

=head1 METHODS

=cut

#
# Uncomment and modify this or add new actions to fit your needs
#
#=head2 default
#
#=cut
#
sub default : Private {
    my ( $self, $c ) = @_;

    # Hello World
    $c->stash->{template} = 'test.tmpl';
    $c->forward( 'PerlFAQ::View::HTC' );
}

# zeige alle Kategorien an
sub index : Private{
    my ( $self, $c ) = @_;
    
    $c->stash->{template} = 'kategorien.tmpl';
    $c->stash->{entries} = [ 
        map{ {
                kategorie => $_->Cat_Name,
                id        => $_->Cat_ID,
             } }$c->model('DBIC::Kategorie')->all 
    ];
    
    $c->forward( 'PerlFAQ::View::HTC' );
}

sub fragen : Local{
    my ( $self, $c, $id ) = @_;
    
    $c->stash->{template}  = 'fragen.tmpl';
    $c->stash->{kategorie} = 
        map{ $_->Cat_Name }$c->model('DBIC::Kategorie')->search(
            {
                Kategorie_ID => $id
            })->all;
    $c->stash->{entries}   = [
        map{ {
                id    => $id,
                fid   => $_->Faq_ID,
                frage => $_->Frage,
             }
        }$c->model('DBIC::Faq')->search({
            Kategorie_ID => $id,
        })->all
    ];
    
    $c->forward( 'PerlFAQ::View::HTC' );
}

sub antwort : Local{
    my ( $self, $c, $id ) = @_;
    
    my ($entry) = $c->model('DBIC::Faq')->search({
        Faq_ID => $id,
    })->all;
    
    $c->stash->{template} = 'antwort.tmpl';
    $c->stash->{frage}    = $entry->Frage;
    $c->stash->{antwort}  = $entry->Antwort;
    
    $c->forward( 'PerlFAQ::View::HTC' );
}


=head1 AUTHOR

A clever guy

=head1 LICENSE

This library is free software, you can redistribute it and/or modify
it under the same terms as Perl itself.

=cut

1;
