#!/usr/bin/perl

use strict;
use Test::More tests => 2;
use Test::WWW::Mechanize;
my $mechanize = Test::WWW::Mechanize->new();

# check "home"
$mechanize->get_ok( 'http://www.foo-magazin.de' );
$mechanize->content_like(qr/Perl/i, "found Perl" );
$mechanize->title_is( '$foo - Perl-Magazin', 'Perl-Magazin title' );

# check "preis"
$mechanize->follow_link_ok( {text => 'Preise'}, 'go to prices' );
$mechanize->content_contains( 'Einzelheft', 'contains price for one magazine' );
$mechanize->content_contains( '6.00 &euro;', 'and there\'s a price of 6 Euro' );