package FooMagazin::ToDoList;

use strict;
use warnings;
use DBI;

use base qw(CGI::Application::Plugin::HTCompiled CGI::Application);

sub setup{
    my ($self) = @_;
    
    $self->_dbh;
    $self->_template( './templates/index.tmpl' );
    
    $self->start_mode( 'show_heads' );
    $self->mode_param( 'action' );
    $self->run_modes(
        show_heads    => \&show_heads,
        show_detail   => \&show_detail,
        update_detail => \&update_detail,
        delete_task   => \&delete_task,
        AUTOLOAD      => \&show_heads,
    );
}

sub show_heads{
    my ($self) = @_;
}

sub show_detail{
    my ($self) = @_;
    my %params = $self->query->Vars;
}

sub update_detail{
    my ($self) = @_;
    my %params = $self->query->Vars;
}

sub delete_task{
    my ($self) = @_;
    my %params = $self->query->Vars;
}

sub do_template{
    my ($self,$hash,$tmpl) = @_;
    
    $tmpl ||= $self->_template;
    
    my $template = $self->load_tmpl( $tmpl );
    $template->param( %$hash );
    return $template->output;
}

sub _dbh{
    my ($self) = @_;
    unless( $self->{dbh}->isa('DBI') ){
        $self->{dbh} = DBI->connect('DBI:SQLite:dbname=todolist','','');
    }

    return $self->{dbh};
}

sub _template{
    my ($self,$tmpl) = @_;
    $self->{template} = $tmpl if defined $tmpl;
    return $self->{template};
}

1;