package FooMagazin::ToDoList_CGI_Ajax;

use strict;
use warnings;
use base qw(CGI::Application::Plugin::HTCompiled CGI::Application);

use DBI;
use CGI::Ajax;
use Data::Dumper;

sub cgiapp_postrun{
    my ($self) = @_;
    $self->_dbh->disconnect;
}

sub setup{
    my ($self) = @_;
    
    $self->_dbh;
    $self->_template( './templates/index_cgi_ajax.tmpl' );
    $self->_url( '/cgi-bin/Ajax_Perl/index_cgi_ajax.cgi' );
    
    $self->start_mode( 'show_heads' );
    $self->mode_param( 'action' );
    $self->run_modes(
        show_heads    => \&show_heads,
        show_detail   => \&show_detail,
        update_detail => \&update_detail,
        delete_task   => \&delete_task,
        AUTOLOAD      => \&show_heads,
    );
}

sub show_heads{
    my ($self) = @_;
    
    my $stmt = q~SELECT ID,Header FROM ToDo~;
    my $sth  = $self->_dbh->prepare( $stmt ) or die $self->_dbh->errstr;
       $sth->execute or die $self->_dbh->errstr;
    my @header;
    while( my ($id,$head) = $sth->fetchrow_array ){
        push @header,{ HEADER => $head, ID => $id };
    }
    $sth->finish;
    
    my $ajax = CGI::Ajax->new( 
        'show_details' => $self->_url,
        'delete2'      => $self->_url,
    );
    $ajax->JSDEBUG(1);
    $ajax->DEBUG(1);
    print $ajax->build_html( $self->query, $self->do_template({ TASKS => \@header }) );
    exit;
}

sub show_detail{
    my ($self) = @_;
    #my %params = $self->query->Vars;
    return "<pre>".Dumper(\$self)."</pre>";
}

sub update_detail{
    my ($self) = @_;
    my %params = $self->query->Vars;
}

sub delete_task{
    my ($self) = @_;
    my %params = $self->query->Vars;
    return "Deleted";
}

sub do_template{
    my ($self,$hash,$tmpl) = @_;
    
    $tmpl ||= $self->_template;
    
    my $template = $self->load_tmpl( $tmpl );
    $template->param( %$hash );
    return $template->output;
}

sub _dbh{
    my ($self) = @_;
    unless( exists $self->{dbh} and $self->{dbh}->isa('DBI') ){
        $self->{dbh} = DBI->connect('DBI:SQLite:dbname=todolist','','');
    }

    return $self->{dbh};
}

sub _url{
    my ($self,$url) = @_;
    
    $self->{url} = $url if defined $url;
    return $self->{url};
}

sub _template{
    my ($self,$tmpl) = @_;
    $self->{template} = $tmpl if defined $tmpl;
    return $self->{template};
}

1;