package FooMagazin::ToDoList_HTML_Prototype;

use strict;
use warnings;
use base qw(CGI::Application::Plugin::HTCompiled CGI::Application);

use DBI;
use HTML::Prototype;
use Data::Dumper;

sub cgiapp_postrun{
    my ($self) = @_;
    $self->_dbh->disconnect;
}

sub setup{
    my ($self) = @_;
    
    $self->_dbh;
    $self->_template( './templates/index_html_prototype2.tmpl' );
    $self->_url( '/cgi-bin/Ajax_Perl/index_html_prototype.cgi' );
    
    $self->start_mode( 'show_heads' );
    $self->mode_param( 'action' );
    $self->run_modes(
        show_heads    => \&show_heads,
        show_detail   => \&show_detail,
        update_detail => \&update_detail,
        delete_task   => \&delete_task,
        AUTOLOAD      => \&show_heads,
    );
}

sub show_heads{
    my ($self) = @_;
    my $pt     = HTML::Prototype->new();
    warn Dumper($self->query);
    
    my $stmt = q~SELECT ID,Header FROM ToDo~;
    my $sth  = $self->_dbh->prepare( $stmt ) or die $self->_dbh->errstr;
       $sth->execute or die $self->_dbh->errstr;
    my @header;
    while( my ($id,$head) = $sth->fetchrow_array ){
        my $delete_link = $pt->link_to_remote( 'Lschen', {
            url    => $self->_url,
            update => 'result'.$id,
            with   => "'action=delete_task;id=$id'",
        });
        my $more_link   = $pt->link_to_remote( 'Aufgabe anzeigen', {
            url    => $self->_url,
            update => 'result'.$id,
            with   => "'action=show_detail;id=$id'",
        });
        push @header,{ 
            HEADER      => $head, 
            ID          => $id,
            DELETE_LINK => $delete_link,
            MORE_LINK   => $more_link,
        };
    }
    $sth->finish;
    
    return $self->do_template({
        TASKS     => \@header,
        PROTOTYPE => $pt->define_javascript_functions,
    });
}

sub echo{
    my ($self) = @_;
    my %params = $self->query->Vars;
    return $params{test};
}

sub show_detail{
    my ($self) = @_;
    warn $self->get_current_runmode;
    #my %params = $self->query->Vars;
    return "<pre>".Dumper(\$self)."</pre>";
}

sub update_detail{
    my ($self) = @_;
    my %params = $self->query->Vars;
}

sub delete_task{
    my ($self) = @_;
    warn $self->get_current_runmode;
    my %params = $self->query->Vars;
    return "Deleted";
}

sub do_template{
    my ($self,$hash,$tmpl) = @_;
    
    $tmpl ||= $self->_template;
    
    my $template = $self->load_tmpl( $tmpl );
    $template->param( %$hash );
    return $template->output;
}

sub _dbh{
    my ($self) = @_;
    unless( exists $self->{dbh} and $self->{dbh}->isa('DBI') ){
        $self->{dbh} = DBI->connect('DBI:SQLite:dbname=todolist','','');
    }

    return $self->{dbh};
}

sub _url{
    my ($self,$url) = @_;
    
    $self->{url} = $url if defined $url;
    return $self->{url};
}

sub _template{
    my ($self,$tmpl) = @_;
    $self->{template} = $tmpl if defined $tmpl;
    return $self->{template};
}

1;