#!/usr/bin/perl

use strict;
use warnings;
use Params::Check::Faster qw(check last_error);
use Data::Dumper;

my $magazine;
my %profile = (
    abotypes => {
        default  => 'JahresAbo',
        allow    => [ 'JahresAbo', 'OnlineAbo' ],
    },
    magazine  => {
        allow    => qr/Perl/,
        store    => \$magazine,
    },
);

my %input = (
    abotypes => 'JahresAbo',
    magazine  => 'The Perl Review',
);

my $var = check( \%profile, \%input, 1 ) or print last_error();
print Dumper($var), " && ", $magazine;

