package Perl::Critic::Policy::FooMagazin;

use strict;
use warnings;
use Perl::Critic::Violation;
use Perl::Critic::Utils qw{ :severities };

use base 'Perl::Critic::Policy';

our $VERSION = '0.01';

my $desc = 'oeffnende Klammer muss in Zeile mit Schleifenkopf sein';
my $expl = q~Es soll in Zukunft also so etwas erzwungen werden wie

  for my $var ( ... ) {

und nicht

  for my $var ( ... )
  {
~;

sub default_severity{
    return $SEVERITY_HIGHEST;
}

sub default_themes{
    return qw/core foo pbp/;
}

sub applies_to{
    return 'PPI::Statement::Compound';
}

sub violates{
    my ($self,$elem,$doc) = @_;
    
    my $base = $elem->schild(0);
    return unless $base eq 'for';
    
    my ($list,$newline,$block);
    
    my @children = $elem->children;
    
    for my $i ( 0 .. $#children ){
        my $child = $children[$i];
        
        if( $child->isa( 'PPI::Structure::Block' ) ){
            $block = $i;
        }
        elsif( $child->isa( 'PPI::Structure::ForLoop' ) ){
            $list = $i;
        }
        elsif( $child->isa( 'PPI::Token::Whitespace' ) and 
               $child eq "\n" and 
               not $newline){
            $newline = $i;
        }
    }
    
    if( $newline and $newline > $list and $newline < $block){
        my $sev = $self->get_severity;
        return Perl::Critic::Violation->new( $desc,$expl,$elem,$sev );
    }

    return;
}

1;

__END__

=pod

=head1 NAME

Perl::Critic::Policy::FooMagazin

=head1 SYNOPSIS

=head1 FUNCTIONS

=head2 default_severity

=head2 default_themes

=head1 AUTHOR

Renee Baecker E<lt>module@renee-baecker.deE<gt>

=cut