#!/usr/bin/perl

use strict;
use warnings;
use PPI;
use PPI::Dumper;

my @codes = (
    q~for my $var (@array){}~, # ok
    q~for my $var (@array)
{}~, # not ok
    q~print $_ for(@array)~, # postfix for loop - ok
    q~
    if(1){
        for(@array){
            print;
        }
    }
    ~, # simulate intended correct for loop
    q~
    if(1){
        for(@array)
        {
            print
        }
    }
    ~, # simulate incorrect intended for loop
);


for my $code ( @codes ){
    my $ppi = PPI::Document->new(\$code);
    my $dumper = PPI::Dumper->new($ppi);
    $dumper->print;
}