#!/usr/bin/perl

use strict;
use warnings;

package TemperatureProbe;
use Moose;

has 'day'   =>  ( isa => 'Num', is => 'rw' );
has 'max'   =>  ( isa => 'Num', is => 'rw' );
has 'min'   =>  ( isa => 'Num', is => 'rw' );
has 'avg'   =>  ( isa => 'Num', is => 'rw' );

package TemperatureTable;
use Moose;

has 'table' =>  ( isa => 'ArrayRef', is => 'rw', default => sub { [] } );

sub parse_file {
  my $self = shift;
  my $fh = shift or die "parse_file() needs a filehandle to parse on.";
  while (<$fh>) {
      next unless /^\s*\d+/;
      my ($day, $max, $min, $avg) = /^\s*(\d+)\s*(\d+)\*?\s*(\d+)\*?\s*(\d+)/;
      my $current = TemperatureProbe->new(
          day => $day, 
          max => $max, 
          min => $min, 
          avg => $avg
      );
      push @{$self->table}, $current;
  }
}

sub get_min_spread_day {
  my $self = shift;
  my %msdy = ( 'day' => 0, 'max' => 1000, 'min' => 0 );
  for my $probe (@{$self->{table}}) {
      if ($probe->max - $probe->min < $msdy{'max'} - $msdy{'min'}) {
          @msdy{'day', 'max', 'min'} = ($probe->day, $probe->max, $probe->min)
      }
  }
  return $msdy{'day'};
}

package main;

my $table = TemperatureTable->new;
$table->parse_file(*DATA);

print $table->get_min_spread_day . "\n";


__DATA__
  
MMU June 2002
  
Dy MxT   MnT   AvT
1  88    59    74
2  79    63    71
3  77    55    66
4  77    59    68
5  90    66    78
6  81    61    71
7  73    57    65
8  75    54    65
9  86    32*   59
mo  82.9  60.5  71.7