#!/usr/bin/perl

use strict;
use warnings;

use Data::Dumper;

package TemperatureProbe;

sub new {
    my $class = shift;
    my @probe = @_;
    
    my $self = { 
        day => $probe[0], 
        max => $probe[1], 
        min => $probe[2], 
        avg => $probe[3], 
    };
    return bless $self, $class;
}

sub day { 
    my $self = shift; 
    $self->{'day'} = shift if @_; 
    return $self->{'day'} 
}

sub max { 
    my $self = shift; 
    $self->{'max'} = shift if @_; 
    return $self->{'max'} 
}

sub min { 
    my $self = shift; 
    $self->{'min'} = shift if @_;
    return $self->{'min'} 
}

sub avg { 
    my $self = shift; 
    $self->{'avg'} = shift if @_; 
    return $self->{'avg'} 
}

package TemperatureTable;

sub new {
    my $class = shift;
    my $self = { table => [] };
    return bless $self, $class;
}

sub parse_file {
    my $self = shift;
    my $fh = shift or die "parse_file() needs a filehandle to parse on.";
    while (<$fh>) {
        next unless /^\s*\d+/;
        my ($day, $max, $min, $avg) = /^\s*(\d+)\s*(\d+)\*?\s*(\d+)\*?\s*(\d+)/;
        my $current = TemperatureProbe->new($day, $max, $min, $avg);
        push @{$self->{table}}, $current;
    }
}

sub get_min_spread_day {
    my $self = shift;
    my %msdy = ( 'day' => 0, 'max' => 1000, 'min' => 0 );
    for my $probe (@{$self->{table}}) {
        if ($probe->max-$probe->min < $msdy{'max'} - $msdy{'min'}) {
            @msdy{'day', 'max', 'min'} = ($probe->day, $probe->max, $probe->min)
        }
    }
    return $msdy{'day'};
}

package main;

my $table = TemperatureTable->new;
$table->parse_file(*DATA);

print $table->get_min_spread_day . "\n";
print Dumper $table;

__DATA__
  
MMU June 2002
  
Dy MxT   MnT   AvT
1  88    59    74
2  79    63    71
3  77    55    66
4  77    59    68
5  90    66    78
6  81    61    71
7  73    57    65
8  75    54    65
9  86    32*   59
mo  82.9  60.5  71.7